//=============================================
// Dragon's Claw
//=============================================
Class DragonsClaw extends WeaponNanoSword;

#exec OBJ LOAD FILE="..\Textures\Effects.utx"

var Name WeaponDamageType;

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local float        mult;
	local name         damageType;
	local DeusExPlayer dxPlayer;

	if (Other != None)
	{
		// AugCombat increases our damage if hand to hand
		mult = 1.0;
		if (bHandToHand && (DeusExPlayer(Owner) != None))
		{
			mult = DeusExPlayer(Owner).AugmentationSystem.GetAugLevelValue(class'AugCombat');
			if (mult == -1.0)
				mult = 1.0;
		}

		// skill also affects our damage
		// GetWeaponSkill returns 0.0 to -0.7 (max skill/aug)
		mult += -2.0 * GetWeaponSkill();

		// Determine damage type
		damageType = WeaponDamageType;

		if (Other != None)
		{
			if (Other.bOwned)
			{
				dxPlayer = DeusExPlayer(Owner);
				if (dxPlayer != None)
					dxPlayer.AISendEvent('Futz', EAITYPE_Visual);
			}
		}
		if ((Other == Level) || (Other.IsA('Mover')))
		{
			if ( Role == ROLE_Authority )
				Other.TakeDamage(HitDamage * mult, Pawn(Owner), HitLocation, 1000.0*X, damageType);

			SelectiveSpawnEffects( HitLocation, HitNormal, Other, HitDamage * mult);
		}
		else if ((Other != self) && (Other != Owner))
		{
			if ( Role == ROLE_Authority )
				Other.TakeDamage(HitDamage * mult, Pawn(Owner), HitLocation, 1000.0*X, damageType);
			if (bHandToHand)
				SelectiveSpawnEffects( HitLocation, HitNormal, Other, HitDamage * mult);

			if (bPenetrating && Other.IsA('Pawn') && !Other.IsA('Robot'))
				SpawnBlood(HitLocation, HitNormal);
		}
	}
   if (DeusExMPGame(Level.Game) != None)
   {
      if (DeusExPlayer(Other) != None)
         DeusExMPGame(Level.Game).TrackWeapon(self,HitDamage * mult);
      else
         DeusExMPGame(Level.Game).TrackWeapon(self,0);
   }
}

state DownWeapon
{
	function BeginState()
	{
		Super.BeginState();
		LightType = LT_None;
		MultiSkins[1]=FireTexture'Effects.Fire.flmethrwr_fire';
		MultiSkins[2]=FireTexture'Effects.Fire.flmethrwr_fire';
		MultiSkins[3]=FireTexture'Effects.Fire.flmethrwr_fire';
		MultiSkins[4]=FireTexture'Effects.Fire.flmethrwr_fire';
		MultiSkins[5]=FireTexture'Effects.Fire.flame_b';
		MultiSkins[6]=None;
		MultiSkins[7]=None;
	}
}

state Idle
{
	function BeginState()
	{
		Super.BeginState();
		LightType = LT_Steady;
		MultiSkins[1]=None;
		MultiSkins[2]=FireTexture'Effects.Fire.flmethrwr_fire';
		MultiSkins[3]=None;
		MultiSkins[4]=FireTexture'Effects.Fire.flmethrwr_fire';
		MultiSkins[5]=FireTexture'Effects.Fire.flame_b';
		MultiSkins[6]=FireTexture'Effects.Fire.flmethrwr_fire';
		MultiSkins[7]=FireTexture'Effects.Fire.flmethrwr_fire';
	}
}

auto state Pickup
{
	function EndState()
	{
		Super.EndState();
		LightType = LT_None;
		MultiSkins[1]=FireTexture'Effects.Fire.flmethrwr_fire';
		MultiSkins[2]=FireTexture'Effects.Fire.flmethrwr_fire';
		MultiSkins[3]=FireTexture'Effects.Fire.flmethrwr_fire';
		MultiSkins[4]=FireTexture'Effects.Fire.flmethrwr_fire';
		MultiSkins[5]=FireTexture'Effects.Fire.flame_b';
		MultiSkins[6]=None;
		MultiSkins[7]=None;
	}
}

defaultproperties
{
     MultiSkins(1)=FireTexture'Effects.Fire.flmethrwr_fire'
     MultiSkins(2)=FireTexture'Effects.Fire.flmethrwr_fire'
     MultiSkins(3)=FireTexture'Effects.Fire.flmethrwr_fire'
     MultiSkins(4)=FireTexture'Effects.Fire.flmethrwr_fire'
     MultiSkins(5)=FireTexture'Effects.Fire.flame_b'
     WeaponDamageType=Flamed
     bHandToHand=True
     mpHitDamage=5
     mpBaseAccuracy=1.000000
     mpAccurateRange=150
     mpMaxRange=150
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     InventoryGroup=365
     ItemName="Dragon's Claw"
     Description="A strange, ancient triad weapon. You would be hard pressed finding out anything else about it."
     beltDescription="DRAGON"
     LightType=LT_Steady
     LightEffect=LE_WateryShimmer
     LightBrightness=224
     LightHue=40
     LightSaturation=64
     LightRadius=4
     Mass=20.000000
}

